// adpcm.cpp
extern VOID Reset8( INT16 val );

extern UINT8 RawDpcm4( INT index );
extern INT16 RawDpcm8( INT index );

extern INT16 Lookup8( INT index );
extern UINT8 Index4( INT32 val );
extern UINT8 Index8( INT32 val );

extern UINT8 Decode4( INT32 val, int index );
extern INT16 Decode8( INT32 val, int index );




// clip.cpp
extern void Fix_Clip16( int lcv );

extern BOOL clip_error, clip_error2;
extern UINT8 dpcm_clip[20];
extern int dpcm_count;





// decode.cpp
extern VOID Check_Limit( int lcv );
extern VOID Decode();
extern VOID Report_Limit();




// noise.cpp
extern VOID Check_Noise();




// Credit: Valery V. Anisimovsky

/*
0x01 ADPCM
0x02 ??
0x04 16-bit
0x08 sign
0x10 stereo
0x80
*/


#pragma pack(1)
struct AUDHeader
{
	UINT8 bID;
	UINT8 bShift;
	CHAR szID[4];
	UINT16 wSampleRate;
	UINT8	bFlags;
	UINT32 dwDataSize;
};




// sierra_aud_scan.cpp
extern FILE *fp, *fp_log;

extern UINT8 buf[0x800000];
extern UINT8 buf_old[0x800000];
extern INT16 pcm[0x800000];
extern INT16 pcm1[0x800000];
extern INT16 pcm2[0x800000];

extern INT32 dpcm_l, dpcm_r;
extern INT32 dpcm_ver;

extern INT32 bit4, wave_num;
extern INT32 overflow_count, noise_count;

extern AUDHeader header;
extern UINT8 stereo, use16;
extern UINT32 start;

extern BOOL overflow, newline;
extern INT error_found;

extern BOOL fix_clip, fix_noise;
extern BOOL check_clip, check_noise;
extern BOOL write_file, dump_file, find_file;
extern BOOL fix_clip_once;

extern INT start_file, stop_file;
