/*-----------------------------------------------------------------------
;
; XRECT - header file
;
;
;
; ****** XLIB - Mode X graphics library                ****************
; ******                                               ****************
; ****** Written By Themie Gouthas                     ****************
;
; egg@dstos3.dsto.gov.au
; teg@bart.dsto.gov.au
;
;  Terminology & notes:
;         VRAM ==   Video RAM
;         SRAM ==   System RAM
;         X coordinates are in pixels unless explicitly stated
;
;-----------------------------------------------------------------------*/

#ifndef _XRECT_H_
#define _XRECT_H_

extern "C" {
/* FUNCTIONS =========================================================== */

extern void x_rect_pattern(      /* draw a pattern filled rectangle      */
         WORD StartX,
         WORD StartY,
         WORD EndX,
         WORD EndY,
         WORD PageBase,
         BYTE far * Pattern);

extern void x_rect_fill(         /* draw a single colour filled rectangle */
         WORD StartX,
         WORD StartY,
         WORD EndX,
         WORD EndY,
         WORD PageBase,
	 WORD color);

extern void x_cp_vid_rect(       /* Copy rect region within VRAM          */
         WORD SourceStartX,
         WORD SourceStartY,
         WORD SourceEndX,
         WORD SourceEndY,
         WORD DestStartX,
         WORD DestStartY,
         WORD SourcePageBase,
         WORD DestPageBase,
         WORD SourceBitmapWidth,
         WORD DestBitmapWidth);

/* Copy a rectangular region of a VGA screen, with x coordinates
 rounded to the nearest byte -- source and destination may overlap. */
extern void x_shift_rect (WORD SrcLeft, WORD SrcTop,
			  WORD SrcRight, WORD SrcBottom,
			  WORD DestLeft, WORD DestTop, WORD ScreenOffs);
}
#endif


