#include "animap.h"
#include "actor.h"
#include "xlib.h"
#include "xtext.h"
#include "xrect.h"
#include "yakpal.h"
#include <conio.h>
#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>

void main(int argcount, char ** argvector)
{
  x_set_mode(2, 380);
  x_set_doublebuffer(260);
  x_text_init();
  yakLib myYakLib("draw");
  yakPalette myYakPalette("standard.ypl", &myYakLib);
  myYakPalette.put();
  char filename[20];
  word thismap_numIcons, thismap_squareWidth, thismap_width, thismap_height;
  animap * mymap;
  if (argcount == 2)
  {
    mymap = new animap(argvector[1], &myYakLib);
  }
  else if (argcount == 6)
  {
    thismap_numIcons = atoi(argvector[1]);
    thismap_squareWidth = atoi(argvector[2]);
    thismap_width = atoi(argvector[3]);
    thismap_height = atoi(argvector[4]);
    mymap = new animap(thismap_numIcons, thismap_squareWidth, thismap_width,
		 thismap_height);
    mymap->loadIcon(0, argvector[5]);
    for (int counter = 1; counter < thismap_numIcons; ++counter)
      mymap->loadIcon(counter, "grid24");
    for (int width_counter = 0; width_counter < thismap_width; ++width_counter)
      for (int height_counter = 0; height_counter < thismap_height; ++height_counter)
	mymap->setSquare(width_counter, height_counter, 0);
  }
  else
  {
    x_text_mode();
    cout << "\n\nMAPEDIT v1.0 21 oct 1992  by  Victor B. Putz\n\nUsage: \n";
    cout << "mapedit filename\n   -- edit map file [filename]\n";
    cout << "mapedit n1 n2 n3 n4 filename\n   -- start a new map with n1 max icons, n2 square width,\n";
    cout << "      n3 width, n4 height, with background icon filename (omit .drw).\n\n";
    exit(EXIT_FAILURE);
  }
  int terrain_number = 0;
  animactor myactor;
  myactor.thisFrame = mymap->iconTable[terrain_number].firstFrame;
  myactor.squareX = mymap->squareWidth-1;
  myactor.squareY = mymap->squareWidth-1;
  myactor.mymap = mymap;
  myactor.put(0,0);
  char exitchar = 'd';
  while (exitchar != 'X')
  {
    mymap->show(myactor.mapX,myactor.mapY, 220 - myactor.squareX,150 - myactor.squareY, 6,4, HiddenPageOffs);
    x_rect_fill(20,20,30,220,HiddenPageOffs,0);     //left
    x_rect_fill(330,20,380,220,HiddenPageOffs,0);  //right
    x_rect_fill(20,20,60,60, HiddenPageOffs,0);     //coords box
//    x_rect_fill(20,215,380,220,HiddenPageOffs,0);  //bottom
//    x_rect_fill(20,20,380,220, HiddenPageOffs, 0);   //top
    x_printf(20,20,HiddenPageOffs, 10, "X: %d", myactor.mapX);
    x_printf(20,30,HiddenPageOffs, 10, "Y: %d", myactor.mapY);
    x_printf(20,40,HiddenPageOffs, 10, "IC:%d", terrain_number);
    x_page_flip(20,20);
    if (kbhit())
    {
      exitchar = getch();
      if (exitchar == 0)
	exitchar = getch();
      switch(exitchar)
      {
	case 72 : myactor.addCommand(scriptNode::fineSlide, 1, 0,0, -mymap->squareWidth); break;
	case 80 : myactor.addCommand(scriptNode::fineSlide, 1, 0,0, mymap->squareWidth); break;
	case 75 : myactor.addCommand(scriptNode::fineSlide, 1, 0, -mymap->squareWidth, 0); break;
	case 77 : myactor.addCommand(scriptNode::fineSlide, 1, 0, mymap->squareWidth,0); break;
	case 71 : myactor.addCommand(scriptNode::fineSlide, 1, 0,-mymap->squareWidth, -mymap->squareWidth); break;
	case 73 : myactor.addCommand(scriptNode::fineSlide, 1, 0,mymap->squareWidth, -mymap->squareWidth); break;
	case 79 : myactor.addCommand(scriptNode::fineSlide, 1, 0,-mymap->squareWidth, mymap->squareWidth); break;
	case 81 : myactor.addCommand(scriptNode::fineSlide, 1, 0,mymap->squareWidth, mymap->squareWidth); break;
	case '>' : ++terrain_number;
		   if (terrain_number == mymap->numIcons)
		     terrain_number = 0;
		     myactor.thisFrame = mymap->iconTable[terrain_number].firstFrame;
		   break;
	case '<' : --terrain_number;
		   if (terrain_number < 0)
		     terrain_number = (mymap->numIcons - 1);
		     myactor.thisFrame = mymap->iconTable[terrain_number].firstFrame;
		   break;
	case ' ' : mymap->setSquare(myactor.mapX, myactor.mapY, terrain_number); break;
	case 'L' : gets(filename);
		   mymap->iconTable[terrain_number].firstFrame = NULL;
		   mymap->loadIcon(terrain_number, filename);
		   if (mymap->iconTable[terrain_number].firstFrame == NULL)
		     mymap->loadIcon(terrain_number, "grid24");
		   mymap->reset();
		   myactor.thisFrame = mymap->iconTable[terrain_number].firstFrame;
		   break;
	case 'S' : gets(filename);
		   mymap->save(filename);
		   break;
      } //switch

    }
  }
  x_text_mode();
}
