
#include <stdio.h>
#include <alloc.h>
#include <mem.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include "xlib_all.h"
#define TITLE "XVIEW - Bitmap Display Utility (Xlib LBM/PBM/CBM formats)    T. Gouthas 20/11/92\n"
#define SRC_EXT ".LBM"
#define DEST_EXT ".CBM"

int convert(char *filenamein, char *filenameout);
void syntax();

typedef struct _lbm_struc {
  unsigned char width;
  unsigned char height;
  unsigned char data[];
} far *LBM_PTR;

#define BUFF_LEN 100

   char drive[MAXDRIVE];
   char dir[MAXDIR];
   char name[MAXFILE];
   char ext[MAXEXT];
   char filenameraw[100];
   char filenamewild[100];
   char filenamein[100];
   char filenameout[100];
   struct ffblk ffb;
   int bgcolor=0;
size_t farfread(void far *destptr,size_t size, size_t n, FILE *fp){
   unsigned len;
   unsigned char buff[BUFF_LEN];
   len=size*n;
   while(len >=BUFF_LEN){
     fread(buff,BUFF_LEN,1,fp);
     movedata((unsigned)_DS,(unsigned)buff,FP_SEG(destptr),FP_OFF(destptr),BUFF_LEN);
     len-=BUFF_LEN;
     (char far *)destptr+=BUFF_LEN;
   }
   if (len>0){
     fread(buff,len,1,fp);
     movedata((unsigned)_DS,(unsigned)buff,FP_SEG(destptr),FP_OFF(destptr),len);
   }
};

size_t farfwrite(void far *srcptr,size_t size, size_t n, FILE *fp){
   unsigned len;
   unsigned char buff[BUFF_LEN];
   len=size*n;
   while(len >=BUFF_LEN){
     movedata(FP_SEG(srcptr),FP_OFF(srcptr),(unsigned)_DS,(unsigned)buff,BUFF_LEN);
     fwrite(buff,BUFF_LEN,1,fp);
     len-=BUFF_LEN;
     (char far *)srcptr+=BUFF_LEN;
   }
   if (len>0){
     movedata(FP_SEG(srcptr),FP_OFF(srcptr),(unsigned)_DS,(unsigned)buff,len);
     fwrite(buff,len,1,fp);
   }
};


int drawfile(char *filenamein,char *ext){
  static char far *ibuff=NULL, far *obuff=NULL;
  static unsigned isize=0, osize=0;
  unsigned width,height;
  FILE *fi;
  char far * farchptr;
  unsigned infilesize,outfilesize;
  fi=fopen(filenamein,"rb+");
  if(!fi) return 0;
  fseek(fi,0,SEEK_END);
  infilesize = (unsigned) ftell(fi);
  fseek(fi,0,SEEK_SET);
  if (ibuff==NULL){
    ibuff=farmalloc(infilesize);
    if (ibuff==NULL) goto error;
    isize=infilesize;
  } else {
    farchptr=farrealloc(ibuff,infilesize);
    if (farchptr==NULL) goto error;
    ibuff=farchptr;
    isize=infilesize;
  }
  farfread(ibuff,infilesize,1,fi);
  if ferror(fi) goto error;
  if (!strcmp(ext,".CBM")){
   x_put_cbitmap(0,10,0,ibuff);
  } else if (!strcmp(ext,".PBM")){
   x_put_pbm(0,10,0,ibuff);
  } else if (!strcmp(ext,".LBM")){
    if (obuff==NULL){
      obuff=farmalloc(infilesize);
      if (obuff==NULL) goto error;
      osize=infilesize;
    } else {
      farchptr=farrealloc(obuff,infilesize);
      if (farchptr==NULL) goto error;
      obuff=farchptr;
      osize=infilesize;
    }
    if(x_bm_to_pbm(ibuff,obuff)){
      infilesize=x_sizeof_cbitmap(80,ibuff);
      if (infilesize>osize){
	 farchptr=farrealloc(obuff,infilesize);
	 if (farchptr==NULL) goto error;
	 obuff=farchptr;
	 osize=infilesize;
      }
      x_compile_bitmap(80,ibuff,obuff);
      x_put_cbitmap(0,10,0,obuff);
    } else
      x_put_pbm(0,10,0,obuff);
  }

  fclose(fi);
  return 1;
error:
  x_text_mode();
  fclose(fi);
  abort();
}

char *intro[9]= {"XVIEW is a general purpose bitmap display utility. It can display \n",
		 "all the XLIB bitmap formats using a user specified palette and    \n",
		 "background colour if necessary. Multiple file specs that may      \n",
		 "include wild card characters can be supplied on the command line. \n",
		 NULL};



void syntax(){
  int i;
  printf("XVIEW [-w <log width>] [-p <palfile>] [-b <bgcolor>] <filespec> [ <filespec> ..] \n\n");
  for(i=0;i<9 && intro[i];i++)
    printf(intro[i]);
  exit(0);
}


void loadpal(char *pal){
  FILE *f;
  unsigned infilesize;
  char far *buff;
  strupr(pal);
  strcpy(filenamewild,pal);


  fnsplit(filenamewild,drive,dir,NULL,ext);
  if (*ext=='\0') strcat(filenamewild,".PAL");
  if(findfirst(filenamewild,&ffb,0)){
    return;
  }
  fnsplit(ffb.ff_name,NULL,NULL,name,ext);
  fnmerge(filenamein,drive,dir,name,ext);
  f=fopen(filenamein,"rb");
  if (!f) return;
  fseek(f,0,SEEK_END);
  infilesize = (unsigned) ftell(f);
  fseek(f,0,SEEK_SET);
  if (infilesize < 768) return;
  buff=farmalloc(infilesize);
  if (buff==NULL) return;
  farfread(buff,infilesize,1,f);
  fclose(f);
  x_put_pal_raw(buff,256,0);
  farfree(buff);
}

void main(int argc, char *argv[]){
   int  i,w;
   char *dotptr;
   char *tempptr;

   printf(TITLE);
   if (argc<2) syntax();

   /* initialize graphics */
   x_set_mode(X_MODE_320x240,80);
   x_text_init();
   x_set_font(0);
   for (i=1;i<argc;i++)
     if (!strcmp(argv[i],"-w")){
       if (argc > i+1){
	 i++;
	 sscanf(argv[i],"%d",&w);
	 x_text_mode();
	 x_set_mode(X_MODE_320x240,w);
       }
     } else if (!strcmp(argv[i],"-p")){
       if (argc > i+1){
	 i++;
	 loadpal(argv[i]);
       }
     } else if (!strcmp(argv[i],"-b")){
       if (argc > i+1){
	 i++;
	 sscanf(argv[i],"%d",&bgcolor);
       }
     } else  {
	strupr(argv[i]);
	strcpy(filenamewild,argv[i]);

	fnsplit(filenamewild,drive,dir,NULL,ext);
	if (*ext=='\0') strcat(filenamewild,SRC_EXT);

	if(findfirst(filenamewild,&ffb,0)){
	  x_text_mode();
	  printf("No files found.\n");
	  exit(1);
	}


	do {
	  x_rect_fill(0,0,319,199,0,bgcolor);
	  fnsplit(ffb.ff_name,NULL,NULL,name,ext);
	  fnmerge(filenamein,drive,dir,name,ext);
	  x_printf(0,0,0,20,"%s",filenamein);
	  drawfile(filenamein,ext);
	  x_printf(0,190,0,20,"Press a key");
	  getch();
	} while(!findnext(&ffb));
      }
   x_text_mode();
}